function blowup(imgElement, options = {}) {
  if (imgElement.tagName.toLowerCase() !== "img") {
    console.error("Blowup.js Error: Target element is not an image.");
    return;
  }

  const defaults = {
    round: true,
    width: 200,
    height: 200,
    background: "#FFF",
    shadow: "0 8px 17px 0 rgba(0, 0, 0, 0.2)",
    border: "6px solid #FFF",
    cursor: true,
    zIndex: 999999,
    scale: 1,
    customClasses: "",
  };

  const settings = { ...defaults, ...options };

  imgElement.addEventListener("dragstart", (event) => event.preventDefault());

  imgElement.style.cursor = settings.cursor ? "crosshair" : "none";

  const lens = document.createElement("div");
  Object.assign(lens.style, {
    position: "absolute",
    display: "none",
    pointerEvents: "none",
    zIndex: settings.zIndex,
    width: `${settings.width}px`,
    height: `${settings.height}px`,
    border: settings.border,
    background: settings.background,
    borderRadius: settings.round ? "50%" : "none",
    boxShadow: settings.shadow,
    backgroundRepeat: "no-repeat",
  });
  lens.className = settings.customClasses;

  document.body.appendChild(lens);

  const lensFn = (event) => {
    const bounds = imgElement.getBoundingClientRect();
    const x = event.pageX - bounds.left - window.pageXOffset;
    const y = event.pageY - bounds.top - window.pageYOffset;

    const backgroundSizeX = imgElement.width * settings.scale;
    const backgroundSizeY = imgElement.height * settings.scale;
    const posX = -((x / imgElement.width) * backgroundSizeX - settings.width / 2);
    const posY = -((y / imgElement.height) * backgroundSizeY - settings.height / 2);

    Object.assign(lens.style, {
      left: `${event.pageX - settings.width / 2}px`,
      top: `${event.pageY - settings.height / 2}px`,
      backgroundImage: `url('${imgElement.src}')`,
      backgroundSize: `${backgroundSizeX}px ${backgroundSizeY}px`,
      backgroundPosition: `${posX}px ${posY}px`,
    });
  };

  imgElement.addEventListener("mouseenter", () => {
    lens.style.display = "block";
    document.addEventListener("mousemove", lensFn);
  });

  imgElement.addEventListener("mouseleave", () => {
    lens.style.display = "none";
    document.removeEventListener("mousemove", lensFn);
  });
}
